import os
import xbmc
import xbmcgui, xbmcvfs
from xbmcaddon import Addon
try: from sqlite3 import dbapi2 as sqlite
except: from pysqlite2 import dbapi2 as sqlite
import xml.etree.ElementTree as ET

DBNAME = "MyVideos75"
ACTION_PREVIOUS_MENU    = 10
ACTION_PARENT_DIR       = 9
ACTION_BACKSPACE = 110
ACTION_BACK = 92
ADDON      = Addon("script.setsmanager")
ADDON_DIR  = ADDON.getAddonInfo("path")
Language = ADDON.getLocalizedString

def log(txt):
    if isinstance (txt,str):
        txt = txt.decode("utf-8")
    message = u'%s' % (txt)
    xbmc.log(msg=message.encode("utf-8"), level=xbmc.LOGDEBUG)

def _advancedsettings():
    as_file = xbmc.translatePath( 'special://profile/advancedsettings.xml' ).decode("utf-8")
    mysql = []
    is_mysql = False
    if xbmcvfs.exists( as_file ):
        tree = ET.parse(as_file)
        root = tree.getroot()
        videodatabase = root.find('videodatabase')
        if videodatabase==None:
            return is_mysql, mysql
        videodatabasetype = videodatabase.find('type').text
        if videodatabasetype == 'mysql':
            is_mysql = True
            mysql.append(videodatabase.find('host').text)
            mysql.append(videodatabase.find('port').text)
            mysql.append(videodatabase.find('user').text)
            mysql.append(videodatabase.find('pass').text)
    return is_mysql, mysql

is_mysql, mysql = _advancedsettings()

if is_mysql:
    log('[SetsManager]: Try connect to MySQL')
    try:
        import MySQLdb
        try:
            db = MySQLdb.connect(host=mysql[0], port=int(mysql[1]), user=mysql[2], passwd=mysql[3], db=DBNAME, charset='utf8')
            cur = db.cursor()
            cur.execute('SET NAMES utf8;')
            cur.execute('SET CHARACTER SET utf8;')
            cur.execute('SET character_set_connection=utf8;')
        except MySQLdb.Error as e:
            xbmcgui.Dialog().ok("Error" ,"%s." % e[1])
    except ImportError as e:
        xbmcgui.Dialog().ok("Error" ,"%s." % e)

else:
    try: from sqlite3 import dbapi2 as sqlite
    except: from pysqlite2 import dbapi2 as sqlite
    database = os.path.join(xbmc.translatePath("special://database"), DBNAME + '.db')
    db = sqlite.connect(database)
    cur = db.cursor()

class SetsManager(xbmcgui.WindowXMLDialog):
    def __init__(self, *args, **kwargs ):
        self.ex = 0
    def onAction(self, action):
        if (action == ACTION_PREVIOUS_MENU or action == ACTION_PARENT_DIR or action == ACTION_BACK):
            self.close()

    def onInit( self ):
        try:
            try:
                self.movieid = int(sys.argv[1])
            except:
                xbmcgui.Dialog().ok("Error" ,"Arguments missing!")
                self.close()
                return
            self.getSets()
            self.getMovieSets()
            self.displaySets()
        except:
            self.close()

    def displaySets( self ):
        self.listSets = self.getControl( 120 )
        listitems = []
        for g in self.sets:
            if int(g[0]) == self.movieSet:
                listitem = xbmcgui.ListItem("%s" % g[1], "%s" % g[0])
                listitem.setIconImage("radiobutton-focus.png")
            else:
                listitem = xbmcgui.ListItem("%s" % g[1], "%s" % g[0])
                listitem.setIconImage("radiobutton-nofocus.png")
            listitems.append(listitem)
        self.listSets.addItems( listitems )

    def getMovieSets(self):
        sql_data = 'SELECT idSet FROM movie WHERE idMovie=%d' % (int(self.movieid))
        cur.execute(sql_data)
        data = cur.fetchone()
        if data[0]>0:
            self.movieSet = int(data[0]) # id of movie's set
        else:
            self.movieSet = 0
    def uncheckItems(self):
        size = self.listSets.size()
        x = 0
        while x < size:
            listitem = self.listSets.getListItem(x)
            listitem.setIconImage("radiobutton-nofocus.png")
            x = x+1
    def getSets(self):
        sql_data = 'SELECT idSet, strSet FROM sets ORDER BY strSet'
        cur.execute(sql_data)
        self.sets = cur.fetchall()

    def setSetArt(self,setid,movieid):
        sql_data = 'SELECT url FROM art WHERE media_id=%d AND media_type="set" AND type="poster"' % (int(setid))
        cur.execute(sql_data)
        data = cur.fetchone()
        if data is None:
            sql_data = 'SELECT url FROM art WHERE media_id=%d AND media_type="movie" AND type="poster"' % (int(movieid))
            cur.execute(sql_data)
            data = cur.fetchone()
            if data is not None:
                cur.execute("INSERT INTO art (media_id,media_type,type,url) VALUES(%d,'set','poster','%s')" % (int(setid),data[0]))
                db.commit()
        sql_data = 'SELECT url FROM art WHERE media_id=%d AND media_type="set" AND type="fanart"' % (int(setid))
        cur.execute(sql_data)
        data = cur.fetchone()
        if data is None:
            sql_data = 'SELECT url FROM art WHERE media_id=%d AND media_type="movie" AND type="fanart"' % (int(movieid))
            cur.execute(sql_data)
            data = cur.fetchone()
            if data is not None:
                cur.execute("INSERT INTO art (media_id,media_type,type,url) VALUES(%d,'set','fanart','%s')" % (int(setid),data[0]))
                db.commit()
    def setSet(self,idSelSet):
        sql_data = 'UPDATE movie SET idSet="%d" WHERE idMovie="%d"' % (int(idSelSet), int(self.movieid))
        cur.execute(sql_data)
        db.commit()
        self.setSetArt(idSelSet,self.movieid)

    def unSet(self,idSelSet):
        sql_data = 'UPDATE movie SET idSet=NULL WHERE idMovie="%d"' % (int(self.movieid))
        cur.execute(sql_data)
        db.commit()

    def onClick( self, controlId ):
        if controlId == 120: #List of sets
            idSelSet = self.sets[self.listSets.getSelectedPosition()][0]
            self.uncheckItems()
            if idSelSet == self.movieSet: #remove set
                self.movieSet = 0
                self.unSet(idSelSet)
            else:
                self.movieSet = idSelSet
                self.setSet(idSelSet)
                self.listSets.getListItem(self.listSets.getSelectedPosition()).setIconImage("radiobutton-focus.png")
        elif controlId == 23: #Edit button
            setsSel = self.listSets.getSelectedItem().getLabel()
            idSelSet = self.sets[self.listSets.getSelectedPosition()][0]
            kb = xbmc.Keyboard(setsSel, 'Edit %s set' % setsSel, False)
            kb.doModal()
            if (kb.isConfirmed()):
                text = kb.getText()
                if not text:
                    xbmcgui.Dialog().ok("Error" ,"Set name is empty!")
                else:
                    sql_data = 'UPDATE sets SET strSet=\"%s\" WHERE idSet=%s' % (text,idSelSet)
                    cur.execute(sql_data)
                    db.commit()
                    self.listSets.reset()
                    self.getSets()
                    self.displaySets()

        elif controlId == 24: #Add button
            kb = xbmc.Keyboard('', 'Enter desired new set', False)
            kb.doModal()
            if (kb.isConfirmed()):
                text = kb.getText()
                if not text:
                    xbmcgui.Dialog().ok("Error" ,"Set name is empty!")
                else:
                    sql_data = 'SELECT idSet FROM sets WHERE strSet=\"%s\"' % (text)
                    cur.execute(sql_data)
                    data = cur.fetchone()
                    if data != None:
                        xbmcgui.Dialog().ok("Error" ,"Set already exist!")
                    else:
                        sql_data = 'INSERT INTO sets (strSet) VALUES (\"%s\")' % (text)
                        cur.execute(sql_data)
                        db.commit()
                        self.listSets.reset()
                        self.getSets()
                        self.displaySets()

        elif controlId == 25: #Del button
            idSelSet = self.sets[self.listSets.getSelectedPosition()][0]
            setsSel = self.listSets.getSelectedItem().getLabel()
            sql_data = 'SELECT count(*) FROM movie WHERE idSet=%s' % (idSelSet)
            cur.execute(sql_data)
            data = cur.fetchone()
            nbmov = data[0]
            if(data[0]>0):
                line = Language(32009).encode("utf-8")
                line = line % (setsSel,nbmov)
            else:
                line = Language(32008).encode("utf-8")
                line = line % (setsSel)
            dialog = xbmcgui.Dialog().yesno('Confirm', line )
            if dialog:
                sql_data = 'UPDATE movie SET idSet=NULL WHERE idSet=%s' % (idSelSet)
                cur.execute(sql_data)
                db.commit()
                sql_data = 'DELETE FROM sets WHERE idSet=%s' % (idSelSet)
                cur.execute(sql_data)
                db.commit()
                sql_data = 'DELETE FROM art WHERE media_id=%s AND media_type="set"' % (idSelSet)
                cur.execute(sql_data)
                db.commit()
                self.listSets.reset()
                self.getSets()
                self.displaySets()

if ( __name__ == "__main__" ):
    ui = SetsManager( "SetsManager.xml", ADDON_DIR, "Default" )
    ui.doModal()
    ex = ui.ex
    del ui
    xbmc.executebuiltin( 'Container.Refresh' )